﻿using Quartz.Impl;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Quartz;
using Quartz.Core;
using System.Collections.Specialized;

namespace QuartzSample.Extensions
{
    public class UnitySchedulerFactory : StdSchedulerFactory
    {
        private readonly UnityJobFactory unityJobFactory;

        public UnitySchedulerFactory(UnityJobFactory unityJobFactory, NameValueCollection props = null)
        {
            if (null != props)
            {
                base.Initialize(props);
            }

            this.unityJobFactory = unityJobFactory;
        }

        protected override IScheduler Instantiate(QuartzSchedulerResources rsrcs, QuartzScheduler scheduler)
        {
            scheduler.JobFactory = this.unityJobFactory;
            return base.Instantiate(rsrcs, scheduler);
        }
    }
}