﻿using QuartzSample.App_Start;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Quartz;
using Quartz.Impl;
using static Quartz.MisfireInstruction;
using Quartz.Impl.Calendar;
using System.IO;
using System.Configuration;
using System.Collections.Specialized;
using QuartzSample.Extensions;

[assembly: WebActivatorEx.PreApplicationStartMethod(typeof(QuartzActivator), "Start")]
[assembly: WebActivatorEx.ApplicationShutdownMethod(typeof(QuartzActivator), "Shutdown")]
namespace QuartzSample.App_Start
{
    public static class QuartzActivator
    {
        public static void Start()
        {
            string configurationFilepath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "quartz.config");
            var configurationFileMap = new ExeConfigurationFileMap { ExeConfigFilename = configurationFilepath };
            var configuration = ConfigurationManager.OpenMappedExeConfiguration(configurationFileMap, ConfigurationUserLevel.None);
            System.Xml.XmlDocument sectionXmlDocument = new System.Xml.XmlDocument();

            sectionXmlDocument.Load(new StringReader(configuration.GetSection("quartz").SectionInformation.GetRawXml()));

            NameValueSectionHandler handler = new NameValueSectionHandler();

            NameValueCollection props = handler.Create(null, null, sectionXmlDocument.DocumentElement) as NameValueCollection;

            ServiceContainer.Current.AddExtension(new QuartzUnityExtension(props));

            ServiceContainer.Resolve<IScheduler>().Start();

        }

        public static void Shutdown()
        {
            ServiceContainer.Resolve<IScheduler>().Shutdown();
        }
    }
}