﻿using Microsoft.Practices.Unity;
using Quartz;
using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Web;
using Microsoft.Practices.Unity.Configuration;


namespace QuartzSample.Extensions
{
    public class QuartzUnityExtension : UnityContainerExtension
    {
        private readonly NameValueCollection quartzProps;

        public QuartzUnityExtension(NameValueCollection quartzProps)
        {
            this.quartzProps = quartzProps;
        }

        protected override void Initialize()
        {
            var constructor = new InjectionConstructor(new UnityJobFactory(this.Container), new InjectionParameter<NameValueCollection>(quartzProps));
            this.Container.RegisterType<ISchedulerFactory, UnitySchedulerFactory>(new ContainerControlledLifetimeManager(),constructor);
            this.Container.RegisterType<IScheduler>(new InjectionFactory(c=>c.Resolve<ISchedulerFactory>().GetScheduler().Result));
        }
    }
}