﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using UserManager.Entities;

namespace UserManager.Security
{
    public class PermissionService : IPermissionService
    {
        private UserManagerContext db = new UserManagerContext();

        public bool Authorize(string permissionName)
        {
            return Authorize(permissionName, WorkContext.CurrentUser);
        }

        public bool Authorize(string permissionName, User user)
        {
            return user.Roles.Where(role => role.Active).Any(role => Authorize(permissionName, role));
        }

        protected virtual bool Authorize(string permissionName, Role role)
        {
            return role.Permissions.Any(p => p.Name.Equals(permissionName, StringComparison.InvariantCultureIgnoreCase));
        }
    }
}