﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using UserManager.Entities;
using UserManager.Models;
using UserManager.Security;

namespace UserManager.Controllers
{
    public class UserController : Controller
    {
        IAuthorizeProvider authorizeProvider = new AuthorizeProvider();

        UserManagerContext db = new UserManagerContext();

        [AllowAnonymous]
        public ActionResult Login(string returnUrl)
        {
            ViewBag.ReturnUrl = returnUrl;
            return View();
        }

        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public ActionResult Login(LoginModel model, string returnUrl)
        {


            if (db.Users.Any(u => u.Name == model.UserName && u.Password == model.Password))
            {
                authorizeProvider.SignIn(new User { Name = model.UserName, Password = model.Password }, model.RememberMe);
                if (!string.IsNullOrWhiteSpace(returnUrl))
                {
                    return Redirect(returnUrl);
                }
                else
                {
                    return RedirectToAction("Index", "Home");
                }
            }
            else
            {
                ModelState.AddModelError(string.Empty, "无效的用户名或密码");
            }

            return View(model);
        }

        [AllowAnonymous]
        public ActionResult SignOut()
        {
            authorizeProvider.SignOut();
            return RedirectToAction(nameof(Login));
        }
    }
}