﻿using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Data.Entity.ModelConfiguration.Conventions;
using System.Reflection;

namespace UserManager.Entities
{
    public class UserManagerContext : DbContext
    {
        static UserManagerContext()
        {
            Database.SetInitializer(new CreateDatabaseIfNotExists<UserManagerContext>());
        }

        public UserManagerContext():base("UserManager")
        {
        }

        public DbSet<User> Users { get; set; }

        public DbSet<Role> Roles { get; set; }

        public DbSet<Permission>Permissions { get; set; }

        public DbSet<EntityPermission> EntityPermissions { get; set; }

        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            modelBuilder.Conventions.Remove<PluralizingTableNameConvention>();
            modelBuilder.Configurations.AddFromAssembly(Assembly.GetExecutingAssembly());
            base.OnModelCreating(modelBuilder);
        }
    }
}