﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.Entity.ModelConfiguration;

namespace UserManager.Entities.Mapping
{
    public class EntityPermissionMap : EntityTypeConfiguration<EntityPermission>
    {
        public EntityPermissionMap()
        {
            this.HasKey(t => new { t.EntityID, t.EntityName, t.RoleID });
            this.Property(t => t.EntityName).HasMaxLength(20);

            this.HasRequired(t=>t.Role).WithMany().HasForeignKey(t=>t.RoleID).WillCascadeOnDelete(true);
        }
    }
}