﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.AspNet.Scaffolding;
using System.ComponentModel.Composition;
using System.Drawing;
using System.Windows.Media;
using System.Windows.Interop;
using System.Windows;
using System.Windows.Media.Imaging;
using CustomScaffolder.Properties;

namespace CustomScaffolder
{
    [Export(typeof(CodeGeneratorFactory))]
    public class CustomCodeGeneratorFactory : CodeGeneratorFactory
    {
        private static CodeGeneratorInformation info = new CodeGeneratorInformation(
              displayName: "零度分享控制器",
              description: "零度分享自定义的控制器",
              author: "断点",
              version: new Version(1, 0, 0, 0),
              id: "CustomCodeGenerator",
              gestures: new[] { "Controller", "View", "Area" },
              categories: new[] { Categories.MvcController, Categories.Common, Categories.Other },
              icon: ToImageSource(Resources.Controller)
              );

        public CustomCodeGeneratorFactory() : base(info)
        {

        }


        public override ICodeGenerator CreateInstance(CodeGenerationContext context)
        {
            return new CustomCodeGenerator(context, info);
        }

        public static ImageSource ToImageSource(Icon icon)
        {
            return Imaging.CreateBitmapSourceFromHIcon(
             icon.Handle,
             Int32Rect.Empty,
             BitmapSizeOptions.FromEmptyOptions()
             );
        }
    }
}
