﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.AspNet.Scaffolding;
using CustomScaffolder.UI;

namespace CustomScaffolder
{
    public class CustomCodeGenerator : CodeGenerator
    {
        private CustomViewModel ViewModel;

        public CustomCodeGenerator(CodeGenerationContext context,CodeGeneratorInformation information):base(context,information)
        {
            this.ViewModel = new CustomViewModel(Context);
        }

        /// <summary>
        /// 自定义代码生成机制
        /// </summary>
        public override void GenerateCode()
        {
            var codeType = ViewModel.SelectModelType.CodeType;
            var parameters = new Dictionary<string, object>();
            parameters.Add("ModelType",codeType);

            this.AddFileFromTemplate(Context.ActiveProject,"CustomCode", "CustomTextTemplate",parameters,true);
        }

        /// <summary>
        /// 弹出自己的对话框
        /// </summary>
        public override bool ShowUIAndValidate()
        {
            MainWindow window = new MainWindow(ViewModel);
            bool? dialogResult = window.ShowDialog();
            return dialogResult ?? false;
        }
    }
}
