﻿using Microsoft.AspNet.Scaffolding;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.AspNet.Scaffolding.EntityFramework;

namespace CustomScaffolder.UI
{
    public class CustomViewModel
    {
        public CodeGenerationContext Context { get; set; }

        public CustomViewModel(CodeGenerationContext Context)
        {
            this.Context = Context;
        }

        public IEnumerable<ModelType> ModeTypes
        {
            get
            {
                var codeService = (ICodeTypeService)Context.ServiceProvider.GetService(typeof(ICodeTypeService));
                return codeService.GetAllCodeTypes(Context.ActiveProject)
                    .Where(c => c.IsValidWebProjectEntityType()).Where(c=>c.Name.EndsWith("Model"))
                    .Select(c => new ModelType(c));
            }
        }

        public ModelType SelectModelType { get; set; }
    }
}
