﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Reflection;
using Plugin;

namespace ConsoleSamples
{
    class Program
    {
        static void Main(string[] args)
        {
            IEnumerable<Type> pluginTypes = GetPluginTypes();

            foreach (Type pluginType in pluginTypes)
            {
                IPlugin plugin = (IPlugin)Activator.CreateInstance(pluginType);
                Console.WriteLine(plugin.HelloWorld());
            }

            Console.ReadKey();
        }

        static IEnumerable<Type> GetPluginTypes()
        {
            string binDir = AppDomain.CurrentDomain.BaseDirectory;
            string pluginDir = System.IO.Path.Combine(binDir, "Plugins");
            string[] files = Directory.GetFiles(pluginDir, "*.dll", SearchOption.TopDirectoryOnly);

            foreach (string file in files)
            {
                Type[] types = Assembly.LoadFrom(file).GetTypes();

                foreach (Type type in types)
                {
                    if (type.IsClass && typeof(IPlugin).IsAssignableFrom(type))
                    {
                        yield return type;
                    }
                }
            }
        }
    }
}
