﻿using CarManager.Core;
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.ComponentModel.Composition.Hosting;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace CarManager.Web.Controllers
{
    public class PaymentController : Controller
    {
        [ImportMany]
        public IEnumerable<PaymentPlugin> Plugins { get; private set; }

        public PaymentController()
        {
            string dir = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Plugins");
            DirectoryCatalog catalog = new DirectoryCatalog(dir);

            CompositionContainer container = new CompositionContainer(catalog);

            container.ComposeParts(this);
        }

        public ActionResult Index()
        {
            return View(Plugins);
        }

        [HttpPost]
        public ActionResult Index(double amount, string payment)
        {
            var plugin = Plugins.Single(p=>p.PluginDescriptor.PluginName==payment);
            if (plugin.Payment(amount))
            {
                ViewBag.Message = "支付成功！";
            }
            else
            {
                ViewBag.Message = "支付失败！";
            }

            return View("Message");
        }
    }
}