﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CarManager.Core
{
    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false, Inherited = false)]
    public class PluginDescriptorAttribute : Attribute
    {
        public PluginDescriptorAttribute(string pluginName, string pluginVersion = null, string author = null)
        {
            this.PluginName = pluginName;
            this.PluginVersion = pluginVersion;
            this.Author = author;
        }

        public string PluginName { get; set; }

        public string PluginVersion { get; set; }

        public string Author { get; set; }
    }
}
