﻿using Microsoft.KtmIntegration;
using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Transactions;

namespace EfSample
{
    public class FileTransactionSample
    {
        public static void ExecuteFileTransaction(string connectionString)
        {
            using (TransactionScope transactionScope = new TransactionScope())
            {
                string commandText = "UPDATE Book SET Price=88.50 WHERE ID=1001";

                var fileStream = TransactedFile.Open(@"log.txt", FileMode.OpenOrCreate, FileAccess.Write, FileShare.Write);
                StreamWriter streamWrite = new StreamWriter(fileStream);
                streamWrite.WriteLine(string.Concat(DateTime.Now, commandText));
                streamWrite.Flush();
                streamWrite.Close();

                SqlConnection connection = new SqlConnection(connectionString);
                SqlCommand command = new SqlCommand(commandText, connection);
                connection.Open();
                command.ExecuteNonQuery();
                connection.Close();

                transactionScope.Complete();
            }
        }
    }
}
