﻿using EfSample.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EntityFramework.Extensions;
using EntityFramework.Caching;
using EntityFramework;

namespace EfSample
{
    public class EfExtendedSample
    {
        public void BatchDelete()
        {
            MyDbContext context = new MyDbContext();
            context.Books.Where(b => b.Price >= 100).Delete();
            context.SaveChanges();
        }

        public void BatchUpdate()
        {
            MyDbContext context = new MyDbContext();
            context.Books.Where(b => b.Price >= 100).Update(b => new Book { Price = 88 });
            context.SaveChanges();
        }

        public void BeatchQuery()
        {
            MyDbContext context = new MyDbContext();

            var books = context.Books.Where(b => b.Price >= 100).Future();
            var accounts = context.Accounts.Where(a => a.Money <= 10).Future();

            var bookList = books.ToList();

            context.SaveChanges();
        }

        public void BeatchQueryPaging(int pageIndex, int pageSize)
        {
            MyDbContext context = new MyDbContext();

            var query = context.Books.Where(b => b.Price >= 100);
            var query1 = query.Skip(pageIndex).Take(pageSize).Future();
            var query2 = query.FutureCount();

            var bookList = query1.ToList();
            var bookTotalCount = query2.Value;
        }

        public void CacheQueryResult()
        {
            MyDbContext context = new MyDbContext();

            var books = context.Books.Where(b => b.Price >= 100).FromCache(); //使用默认缓存
            var books2 = context.Books.Where(b => b.Price >= 100).FromCache(CachePolicy.WithDurationExpiration(TimeSpan.FromSeconds(300))); //将结果缓存300秒
        }


        public void CacheQueryResultTags()
        {
            MyDbContext context = new MyDbContext();

            var books = context.Books.Where(b => b.Price >= 100).FromCache(tags: new[] { "Books", "100" });
            CacheManager.Current.Expire("Books"); //让标记为Books的缓存立即过期

        }

        public void CustomCacheProvider()
        {
            //Locator.Current.Register<ICacheProvider>(() => new MemcachedProvider());
        }
    }
}
