﻿using EfSample.Models;
using System;
using System.Collections.Generic;
using System.Data.Entity.Infrastructure;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EfSample.Concurrency
{
    public class ConcurrencySample
    {
        /// <summary>
        /// EF默认使用积极并发处理
        /// </summary>
        public void PositiveConcurrencyTest()
        {
            MyDbContext context1 = new MyDbContext();
            MyDbContext context2 = new MyDbContext();

            var book1 = context1.Books.Find(1);
            var book2 = context2.Books.Find(1);

            book1.Price = 111;

            book2.Name = "C+++";

            context1.SaveChanges();
            context2.SaveChanges();

        }

        /// <summary>
        /// 微软EF团队推荐处理并发的方式
        /// </summary>
        public void PositiveConcurrencyExceptionTest()
        {
            try
            {
                MyDbContext context1 = new MyDbContext();
                MyDbContext context2 = new MyDbContext();

                var book1 = context1.Books.Find(1);
                var book2 = context2.Books.Find(1);

                book1.Price = 111;
                book2.Name = "C+++";

                context1.SaveChanges();

                context2.SaveChanges();
            }
            catch (DbUpdateConcurrencyException e)
            {
                e.Entries.Single().Reload();
            }
        }
    }
}
