﻿using EfSample.Models;
using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Transactions;

namespace EfSample.Transaction
{
    public class EfTransactionSample
    {
        public void DefaultTransactionTest()
        {
            MyDbContext context = new MyDbContext();
            context.Database.Log = Console.WriteLine;

            var book = context.Books.Find(1);
            var account = context.Accounts.Find(1);

            book.Name = "F#";
            account.Money = 888;

            context.SaveChanges();
        }


        public void TransactionScopeTest()
        {
            using (var ts = new TransactionScope(TransactionScopeOption.Required))
            {
                MyDbContext context1 = new MyDbContext();
                MyDbContext context2 = new MyDbContext();

                var book = context1.Books.Find(1);
                var account = context2.Accounts.Find(1);

                book.Name = "F#";
                account.Money = 888;

                context1.SaveChanges();
                context2.SaveChanges();

                ts.Complete();
            }
        }

        public void Ef6TransactionTest()
        {
            MyDbContext context = new MyDbContext();

            using (var transaction = context.Database.BeginTransaction())
            {
                try
                {
                    var sql = "UPDATE Account SET [Money]=[Money]-10 WHERE Name=@Name";
                    context.Database.ExecuteSqlCommand(sql, new SqlParameter("@Name", "A"));

                    var book = context.Books.Find(1);
                    var account = context.Accounts.Find(1);
                    book.Name = "F#";
                    context.SaveChanges();

                    transaction.Commit();
                }
                catch
                {
                    transaction.Rollback();
                }
            }

        }

        public void ExistTransactionText()
        {
            using (var connection = new SqlConnection("ConnectionString"))
            {
                connection.Open();
                using (var sqlTransaction = connection.BeginTransaction( ))
                {
                    try
                    {
                        SqlCommand sqlCommand = new SqlCommand();
                        sqlCommand.Connection = connection;
                        sqlCommand.Transaction = sqlTransaction;
                        sqlCommand.CommandText ="UPDATE Account SET [Money]=[Money]-10 WHERE ID=1";
                        sqlCommand.ExecuteNonQuery();


                        MyDbContext context = new MyDbContext(connection);
                        context.Database.UseTransaction(sqlTransaction);
                        var book = context.Books.Find(1);
                        var account = context.Accounts.Find(1);
                        book.Name = "F#";
                        context.SaveChanges();

                        sqlTransaction.Commit();
                    }
                    catch
                    {
                        sqlTransaction.Rollback();
                    }


                }
            }
        }

    }
}
