﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Transactions;

namespace EfSample
{
    public class TransactionScopeSample
    {
        public static void ExecuteTransactionScope(string connectionString1, string connectionString2)
        {
            string commandText1 = "UPDATE Account SET [Money]=[Money]-10 WHERE Name='A'";
            string commandText2 = "UPDATE Account SET [Money]=[Money]+10 WHERE Name='B'";

            using (TransactionScope scope = new TransactionScope())
            {
                using (SqlConnection connection1 = new SqlConnection(connectionString1))
                {
                    connection1.Open();
                    SqlCommand command1 = new SqlCommand(commandText1, connection1);
                    command1.ExecuteNonQuery();

                    using (SqlConnection connection2 = new SqlConnection(connectionString2))
                    {
                        connection2.Open();
                        SqlCommand command2 = new SqlCommand(commandText2, connection2);
                        command2.ExecuteNonQuery();
                    }
                }
                scope.Complete();
            }
        }
    }
}
