﻿using FooModule.DataAccess.Dapper;
using System.Threading.Tasks;
using Volo.Abp.Application.Services;

namespace FooModule.DataAccess
{
    public class DogAppService : ApplicationService
    {
        private readonly IDogDapperRepository _dogRepository;

        public DogAppService(IDogDapperRepository dogRepository)
        {
            _dogRepository = dogRepository;
        }

        public async Task<object> GetListAsync()
        {
            await _dogRepository.Create(new DogEntry { Name = "Dog4", Age = 44 });

            await _dogRepository.Delete(1);

            await _dogRepository.Update(new DogEntry { Id = 2, Name = "Dog222", Age = 222 });

            var dogs = await _dogRepository.GetAll();

            return new { dogs };
        }
    }
}