﻿using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic.Core;
using System.Threading.Tasks;
using Volo.Abp.Application.Services;
using Volo.Abp.Data;
using Volo.Abp.Domain.Repositories;
using Volo.Abp.Linq;

namespace FooModule.DataAccess
{
    public class DogAppService : ApplicationService
    {
        private readonly IDogRepository _dogRepository;

        private readonly IRepository<Dog, int> _dogDefaultRepository;

        private readonly IAsyncQueryableExecuter _asyncExecuter;

        public DogAppService(IDogRepository dogRepository, IRepository<Dog, int> dogRepository2, IAsyncQueryableExecuter asyncExecuter)
        {
            _dogRepository = dogRepository;
            _dogDefaultRepository = dogRepository2;
            _asyncExecuter = asyncExecuter;

        }

        public async Task<object> GetListAsync()
        {
            Dog dog1 = await _dogDefaultRepository.FindAsync(1);

            Dog dog2 = _dogRepository.Where(d => d.Name == "Dog2").First();

            dog1.SetProperty("Remark", "Dog1Remark");

            await _dogRepository.UpdateAsync(dog1);

            string dog1Remark = dog1.GetProperty<string>("Remark");

            await _dogRepository.DeleteDogsByAge(11);

            List<Dog> dogs1 = await _dogRepository.Where(d => d.Age > 1).OrderBy(p => p.Name).ToListAsync();

            var query = _dogRepository.Where(p => p.Age > 1).OrderBy(p => p.Name);
            List<Dog> dogs2 = await _asyncExecuter.ToListAsync(query);

            List<Dog> dogs3 = await AsyncExecuter.ToListAsync(query);

            return new { dog1, dog2, dog1Remark, dogs1, dogs2 };
        }
    }
}