﻿using System.Linq;
using System.Threading.Tasks;
using Volo.Abp.Application.Services;
using Volo.Abp.Data;
using Volo.Abp.Domain.Repositories;

namespace FooModule.DataAccess
{
    public class DogAppService : ApplicationService
    {
        private readonly IRepository<Dog, int> _dogRepository;

        public DogAppService(IRepository<Dog, int> dogRepository)
        {
            _dogRepository = dogRepository;
        }

        public async Task<object> GetListAsync()
        {
            Dog dog1 = await _dogRepository.FindAsync(1);

            Dog dog2 = _dogRepository.Where(d => d.Name == "Dog2").First();

            dog1.SetProperty("Remark", "Dog1Remark");

            await _dogRepository.UpdateAsync(dog1);

            string dog1Remark = dog1.GetProperty<string>("Remark");

            return new { dog1, dog2, dog1Remark };
        }
    }
}