using FooModule.AuditLogging;
using FooModule.Authorization;
using FooModule.DynamicProxy;
using FooModule.EntityFramework;
using FooModule.Features;
using FooModule.Localization;
using FooModule.Services;
using FooModule.Settings;
using Microsoft.AspNetCore.Authentication.Cookies;
using Microsoft.AspNetCore.Builder;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using System;
using System.Net;
using Volo.Abp;
using Volo.Abp.AspNetCore.ExceptionHandling;
using Volo.Abp.AspNetCore.Mvc;
using Volo.Abp.AspNetCore.Mvc.UI.Theme.Basic;
using Volo.Abp.AspNetCore.Serilog;
using Volo.Abp.AspNetCore.VirtualFileSystem;
using Volo.Abp.Auditing;
using Volo.Abp.AuditLogging.EntityFrameworkCore;
using Volo.Abp.Authorization.Permissions;
using Volo.Abp.Autofac;
using Volo.Abp.AutoMapper;
using Volo.Abp.Caching;
using Volo.Abp.Data;
using Volo.Abp.EntityFrameworkCore;
using Volo.Abp.EntityFrameworkCore.SqlServer;
using Volo.Abp.Features;
using Volo.Abp.Localization;
using Volo.Abp.Localization.ExceptionHandling;
using Volo.Abp.Modularity;
using Volo.Abp.PermissionManagement;
using Volo.Abp.PermissionManagement.EntityFrameworkCore;
using Volo.Abp.PermissionManagement.Localization;
using Volo.Abp.PermissionManagement.Web;
using Volo.Abp.Security.Claims;
using Volo.Abp.SettingManagement.EntityFrameworkCore;
using Volo.Abp.SettingManagement.Web;
using Volo.Abp.SettingManagement.Web.Pages.SettingManagement;
using Volo.Abp.Settings;
using Volo.Abp.Validation.Localization;
using Volo.Abp.VirtualFileSystem;

namespace FooModule
{
    [DependsOn(typeof(AbpAspNetCoreMvcModule))]
    [DependsOn(typeof(AbpVirtualFileSystemModule))]
    [DependsOn(typeof(AbpLocalizationModule))]
    [DependsOn(typeof(AbpAutofacModule))]
    [DependsOn(typeof(AbpCachingModule))]
    [DependsOn(typeof(AbpPermissionManagementWebModule), typeof(AbpPermissionManagementApplicationModule), typeof(AbpPermissionManagementEntityFrameworkCoreModule), typeof(AbpEntityFrameworkCoreSqlServerModule))]
    [DependsOn(typeof(AbpAspNetCoreMvcUiBasicThemeModule))]
    [DependsOn(typeof(AbpAspNetCoreSerilogModule))]
    [DependsOn(typeof(AbpAuditLoggingEntityFrameworkCoreModule))]
    [DependsOn(typeof(AbpSettingManagementWebModule), typeof(AbpSettingManagementEntityFrameworkCoreModule))]
    public class FoobarModule : AbpModule
    {
        public override void PreConfigureServices(ServiceConfigurationContext context)
        {
            base.PreConfigureServices(context);

            context.Services.OnRegistred(register =>
            {
                if (register.ImplementationType == typeof(HelloWorldService))
                {
                    register.Interceptors.Add<CustomAbpInterceptor>();
                }
            });
        }

        public override void ConfigureServices(ServiceConfigurationContext context)
        {
            base.ConfigureServices(context);

            Configure<AbpVirtualFileSystemOptions>(options =>
            {
                options.FileSets.AddEmbedded<FoobarModule>();
            });

            Configure<AbpAspNetCoreContentOptions>(options =>
            {
                options.AllowedExtraWebContentFileExtensions.Add(".json");
                options.AllowedExtraWebContentFolders.Add("/FooModule");
            });

            Configure<AbpLocalizationOptions>(options =>
            {
                options.DefaultResourceType = typeof(TestResource);

                options.Resources.Add<TestResource>("zh-Hans")
                .AddVirtualJson("/FooModule/MyResources/Localization")
                .AddBaseTypes(typeof(AbpValidationResource))
                .AddBaseTypes(typeof(AbpPermissionManagementResource));

                options.Languages.Add(new LanguageInfo("en", "en", "English"));
                options.Languages.Add(new LanguageInfo("zh-Hans", "zh-Hans", "简体中文"));
            });

            Configure<AbpExceptionLocalizationOptions>(options =>
            {
                options.MapCodeNamespace("Foo", typeof(TestResource));
            });

            Configure<AbpExceptionHttpStatusCodeOptions>(options =>
            {
                options.Map("Foo:001", HttpStatusCode.OK);
            });

            Configure<AbpAspNetCoreMvcOptions>(options =>
            {
                options.ConventionalControllers.Create(typeof(FoobarModule).Assembly);
            });

            Configure<AbpDistributedCacheOptions>(options =>
            {
                options.HideErrors = false;
                options.GlobalCacheEntryOptions.SlidingExpiration = TimeSpan.FromMinutes(10);
                options.KeyPrefix = "CutomAppName";
            });

            context.Services.AddAuthentication(CookieAuthenticationDefaults.AuthenticationScheme).AddCookie();

            context.Services.AddAuthorization(options =>
            {
                options.AddPolicy("MyPolicy1", policy => policy.RequireAuthenticatedUser());
                options.AddPolicy("MyPolicy2", policy => policy.RequireClaim(AbpClaimTypes.TenantId));
            });

            Configure<AbpPermissionOptions>(options =>
            {
                options.ValueProviders.Add<TenantPermissionValueProvider>();
            });

            //if (context.Services.GetHostingEnvironment().IsDevelopment())
            //{
            //    context.Services.AddAlwaysAllowAuthorization();
            //}

            Configure<AbpDbContextOptions>(options =>
            {
                options.UseSqlServer();
            });

            context.Services.AddAbpDbContext<HelloWorldDbContext>(options =>
            {
                options.AddDefaultRepositories(includeAllEntities: true);
            });

            Configure<PermissionManagementOptions>(options =>
            {
                options.ManagementProviders.Add<MyUserPermissionManagementProvider>();
                options.ManagementProviders.Add<MyRolePermissionManagementProvider>();

                options.ProviderPolicies.Add(UserPermissionValueProvider.ProviderName, MyPermissions.Cats.Default);
                options.ProviderPolicies.Add(RolePermissionValueProvider.ProviderName, MyPermissions.Cats.Default);
            });

            Configure<AbpAspNetCoreSerilogOptions>(options =>
            {
                options.EnricherPropertyNames.UserId = "UserID";
            });

            Configure<AbpAutoMapperOptions>(options =>
            {
                options.AddMaps<FoobarModule>();
            });

            Configure<AbpAuditingOptions>(options =>
            {
                options.IsEnabled = true; //Disables the auditing system
                options.IsEnabledForGetRequests = true;
                options.EntityHistorySelectors.AddAllEntities();

                options.Contributors.Add(new MyAuditLogContributor());
            });

            Configure<AbpSettingOptions>(options =>
            {
                options.ValueProviders.Add<CustomSettingValueProvider>();
            });

            Configure<SettingManagementPageOptions>(options =>
            {
                options.Contributors.Add(new MySettingPageContributor());
            });

            Configure<AbpFeatureOptions>(options =>
            {
                options.ValueProviders.Add<MyFeatureValueProvider>();
            });

        }

        public override void OnApplicationInitialization(ApplicationInitializationContext context)
        {
            context.ServiceProvider.GetRequiredService<IDataSeeder>().SeedAsync().Wait();

            var app = context.GetApplicationBuilder();
            var env = context.GetEnvironment();

            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            else
            {
                app.UseExceptionHandler("/Error");
            }

            app.UseVirtualFiles();

            app.UseStaticFiles();
            app.UseRouting();

            app.UseAbpRequestLocalization();

            app.UseAuthentication().UseAuthorization();

            app.UseAbpSerilogEnrichers();

            app.UseAuditing();

            app.UseConfiguredEndpoints(options =>
            {
                options.MapControllerRoute("app1", "{controller=home}/{action=Index}/{id?}");
            });
        }
    }
}