﻿using FooModule.AuditLogging;
using Microsoft.EntityFrameworkCore;
using Volo.Abp;
using Volo.Abp.EntityFrameworkCore.Modeling;

namespace FooModule.EntityFramework
{
    public static class HelloWorldDbContextModelCreatingExtensions
    {
        public static void ConfigureAppleStore(this ModelBuilder modelBuilder)
        {
            Check.NotNull(modelBuilder, nameof(modelBuilder));

            modelBuilder.Entity<Apple>(b =>
            {
                b.ToTable("Apples", "Foo");
                b.ConfigureByConvention();
                b.HasKey(x => x.Id);
                b.Property(x => x.Name).IsRequired().HasMaxLength(128);
            });
        }
    }
}
