﻿using FooModule.Localization;
using Volo.Abp.Authorization.Permissions;
using Volo.Abp.Localization;

namespace FooModule.Authorization
{
    public class MyPermissionDefinitionProvider : PermissionDefinitionProvider
    {
        public override void Define(IPermissionDefinitionContext context)
        {
            var catGroup = context.AddGroup(MyPermissions.GroupName, L("Permission:CatStore"));

            var catManagement = catGroup.AddPermission(MyPermissions.Cats.Default);

            catManagement.AddChild(MyPermissions.Cats.Create, L("Permission:Cats.Create"));
            catManagement.AddChild(MyPermissions.Cats.Edit);
            catManagement.AddChild(MyPermissions.Cats.Delete);
        }

        private static LocalizableString L(string name)
        {
            return LocalizableString.Create<TestResource>(name);
        }
    }
}