﻿using FooModule.Localization;
using Volo.Abp.Authorization.Permissions;
using Volo.Abp.Localization;

namespace FooModule.Authorization
{
    public class MyPermissionDefinitionProvider : PermissionDefinitionProvider
    {
        public override void Define(IPermissionDefinitionContext context)
        {
            var myGroup = context.AddGroup("CatStore", LocalizableString.Create<TestResource>("CatStore"));

            var catManagement = myGroup.AddPermission("Cat_Management");

            catManagement.AddChild("Cat_Management_Create_Cats", isEnabled: false);
            catManagement.AddChild("Cat_Management_Edit_Cats");
            catManagement.AddChild("Cat_Management_Delete_Cats");

            //context.GetPermissionOrNull("<PermissionName>").IsEnabled = false;
        }
    }
}