﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Volo.Abp.Authorization.Permissions;
using Volo.Abp.DependencyInjection;

namespace FooModule.Authorization
{
    [Dependency(ReplaceServices = true)]
    public class MyPermissionStore : IPermissionStore, ISingletonDependency
    {
        private static List<Tuple<string, string, string>> acls = new List<Tuple<string, string, string>>()
        {
           new Tuple<string, string, string>("Cat_Management","U","userid1"),
           new Tuple<string, string, string>("Cat_Management","U","userid2"),
           new Tuple<string, string, string>("Cat_Management","U","userid3"),
           new Tuple<string, string, string>("Cat_Management","U","userid4"),

           new Tuple<string, string, string>("Cat_Management_Create_Cats","R","myrole1"),

           new Tuple<string, string, string>("Cat_Management_Edit_Cats","R","myrole2"),

           new Tuple<string, string, string>("Cat_Management_Delete_Cats","C","myclient3"),

           new Tuple<string, string, string>("Cat_Management_Create_Cats","T","643ce51d-3624-4c4e-8aa4-543057942604")
        };

        public async Task<bool> IsGrantedAsync(string name, string providerName, string providerKey)
        {
            await Task.CompletedTask;

            return acls.Any(ac => ac.Item1 == name && ac.Item2 == providerName && ac.Item3 == providerKey);
        }
    }
}