﻿using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace AspNetCoreMvcSample
{
    public class TimedHostedService : IHostedService
    {
        private static List<long> tickList = new List<long>();

        public async Task StartAsync(CancellationToken cancellationToken)
        {
            while (!cancellationToken.IsCancellationRequested)
            {
                await DoWork(DateTime.Now);
                await Task.Delay(1);
            }
        }

        public Task StopAsync(CancellationToken cancellationToken)
        {
            return Task.CompletedTask;
        }

        private async Task DoWork(DateTime dateTime)
        {
            tickList.Add(dateTime.Ticks);

            Console.WriteLine(dateTime.Ticks);

            await Task.CompletedTask;
        }
    }
}
