﻿using FooModule.DynamicProxy;
using FooModule.Localization;
using FooModule.Services;
using Microsoft.AspNetCore.Builder;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using System.Net;
using Volo.Abp;
using Volo.Abp.AspNetCore.ExceptionHandling;
using Volo.Abp.AspNetCore.Mvc;
using Volo.Abp.AspNetCore.VirtualFileSystem;
using Volo.Abp.Autofac;
using Volo.Abp.Localization;
using Volo.Abp.Localization.ExceptionHandling;
using Volo.Abp.Modularity;
using Volo.Abp.Validation.Localization;
using Volo.Abp.VirtualFileSystem;

namespace FooModule
{
    [DependsOn(typeof(AbpAspNetCoreMvcModule))]
    [DependsOn(typeof(AbpVirtualFileSystemModule))]
    [DependsOn(typeof(AbpLocalizationModule))]
    [DependsOn(typeof(AbpAutofacModule))]
    public class FoobarModule : AbpModule
    {
        public override void PreConfigureServices(ServiceConfigurationContext context)
        {
            base.PreConfigureServices(context);

            context.Services.OnRegistred(register =>
            {
                if (register.ImplementationType == typeof(HelloWorldService))
                {
                    register.Interceptors.Add<CustomAbpInterceptor>();
                }
            });
        }

        public override void ConfigureServices(ServiceConfigurationContext context)
        {
            base.ConfigureServices(context);

            Configure<AbpVirtualFileSystemOptions>(options =>
            {
                options.FileSets.AddEmbedded<FoobarModule>("FooModule.MyResources", "/MyResources");
            });

            Configure<AbpAspNetCoreContentOptions>(options =>
            {
                options.AllowedExtraWebContentFileExtensions.Add(".json");
                options.AllowedExtraWebContentFolders.Add("/Localization");
            });

            Configure<AbpLocalizationOptions>(options =>
            {
                options.DefaultResourceType = typeof(TestResource);

                options.Resources.Add<TestResource>("zh-Hans")
                .AddVirtualJson("/Localization")
                .AddBaseTypes(typeof(AbpValidationResource));

                options.Languages.Add(new LanguageInfo("en", "en", "English"));
                options.Languages.Add(new LanguageInfo("zh-Hans", "zh-Hans", "简体中文"));
            });

            Configure<AbpExceptionLocalizationOptions>(options =>
            {
                options.MapCodeNamespace("Foo", typeof(TestResource));
            });

            Configure<AbpExceptionHttpStatusCodeOptions>(options =>
            {
                options.Map("Foo:001", HttpStatusCode.OK);
            });

            Configure<AbpAspNetCoreMvcOptions>(options =>
            {
                options.ConventionalControllers.Create(typeof(FoobarModule).Assembly);
            });
        }

        public override void OnApplicationInitialization(ApplicationInitializationContext context)
        {
            var app = context.GetApplicationBuilder();
            var env = context.GetEnvironment();

            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            else
            {
                app.UseExceptionHandler("/Error");
            }

            app.UseVirtualFiles();

            app.UseStaticFiles();
            app.UseRouting();

            app.UseAbpRequestLocalization();

            app.UseConfiguredEndpoints(options =>
            {
                options.MapControllerRoute("app1", "{controller=home}/{action=Index}/{id?}");
            });
        }
    }
}
