using Microsoft.AspNetCore.Builder;
using Microsoft.Extensions.Hosting;
using System.Net;
using Volo.Abp;
using Volo.Abp.AspNetCore.ExceptionHandling;
using Volo.Abp.AspNetCore.Mvc;
using Volo.Abp.AspNetCore.VirtualFileSystem;
using Volo.Abp.Localization;
using Volo.Abp.Localization.ExceptionHandling;
using Volo.Abp.Modularity;
using Volo.Abp.Validation.Localization;
using Volo.Abp.VirtualFileSystem;

namespace ClassLibrary1
{
    [DependsOn(typeof(AbpAspNetCoreMvcModule))]
    [DependsOn(typeof(AbpVirtualFileSystemModule))]
    [DependsOn(typeof(AbpLocalizationModule))]
    public class App1Module : AbpModule
    {
        public override void ConfigureServices(ServiceConfigurationContext context)
        {
            Configure<AbpVirtualFileSystemOptions>(options =>
            {
                options.FileSets.AddEmbedded<App1Module>("ClassLibrary1.MyResources", "/MyResources");
            });

            Configure<AbpAspNetCoreContentOptions>(options =>
            {
                options.AllowedExtraWebContentFileExtensions.Add(".html");
                options.AllowedExtraWebContentFolders.Add("/");
            });

            Configure<AbpLocalizationOptions>(options =>
            {
                options.DefaultResourceType = typeof(TestResource);

                options.Resources.Add<TestResource>("en").AddVirtualJson("/Localization").AddBaseTypes(typeof(AbpValidationResource)); ;

                //options.Resources.Get<AbpValidationResource>().AddVirtualJson("/Localization");
            });

            Configure<AbpExceptionLocalizationOptions>(options =>
            {
                options.MapCodeNamespace("App1", typeof(TestResource));
            });

            Configure<AbpExceptionHttpStatusCodeOptions>(options =>
            {
                options.Map("App1:010002", HttpStatusCode.OK);
            });

            base.ConfigureServices(context);
        }

        public override void OnApplicationInitialization(ApplicationInitializationContext context)
        {
            var app = context.GetApplicationBuilder();
            var env = context.GetEnvironment();

            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            else
            {
                app.UseExceptionHandler("/Error");
            }

            app.UseRequestLocalization("en", "zh-Hans");

            app.UseVirtualFiles();

            app.UseStaticFiles();

            app.UseRouting();

            app.UseConfiguredEndpoints(options =>
            {
                options.MapControllerRoute("app1", "{controller=App1}/{action=Index}/{id?}");
            });
        }
    }
}
