﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.FileProviders;
using Microsoft.Extensions.Localization;
using System.Threading.Tasks;
using Volo.Abp.AspNetCore.Mvc;
using Volo.Abp.Http;
using Volo.Abp.VirtualFileSystem;

namespace ClassLibrary1
{
    public class App1Controller : AbpController
    {
        private readonly IVirtualFileProvider _virtualFileProvider;

        private readonly IStringLocalizer<TestResource> _localizer;

        public App1Controller(IVirtualFileProvider virtualFileProvider, IStringLocalizer<TestResource> localizer)
        {
            _virtualFileProvider = virtualFileProvider;
            _localizer = localizer;
        }

        public IActionResult Index()
        {
            return Content("App1 Hello World!");
        }

        public async Task<IActionResult> Text()
        {
            var fileInfo = _virtualFileProvider.GetFileInfo("/Hello.html");

            //var diectory = _virtualFileProvider.GetDirectoryContents("/ClassLibrary1/MyResources");

            //var fileString = await fileInfo.ReadAsStringAsync();
            //return Content(fileString);

            var fileBytes = await fileInfo.ReadBytesAsync();

            return File(fileBytes, MimeTypes.Text.Html);
        }

        public IActionResult Hello()
        {
            //string str = _localizer["HelloWorld"];

            string str = _localizer.GetString("HelloWorld");

            return Content(str);
        }

        public IActionResult Hello2()
        {
            string str1 = _localizer["HelloWorld2", "ZhanSan"];

            string str2 = _localizer.GetString("HelloWorld2", "LiSi");

            return Content(str1 + str2);
        }
    }
}
