using Microsoft.AspNetCore.Builder;
using Microsoft.Extensions.Hosting;
using Volo.Abp;
using Volo.Abp.AspNetCore.Mvc;
using Volo.Abp.AspNetCore.VirtualFileSystem;
using Volo.Abp.Modularity;
using Volo.Abp.VirtualFileSystem;

namespace ClassLibrary1
{
    [DependsOn(typeof(AbpAspNetCoreMvcModule))]
    [DependsOn(typeof(AbpVirtualFileSystemModule))]
    public class App1Module : AbpModule
    {
        public override void ConfigureServices(ServiceConfigurationContext context)
        {
            Configure<AbpVirtualFileSystemOptions>(options =>
            {
                options.FileSets.AddEmbedded<App1Module>("ClassLibrary1.MyResources", "/MyResources");
            });

            Configure<AbpAspNetCoreContentOptions>(options =>
            {
                options.AllowedExtraWebContentFileExtensions.Add(".html");
                options.AllowedExtraWebContentFolders.Add("/");
            });

            base.ConfigureServices(context);
        }

        public override void OnApplicationInitialization(ApplicationInitializationContext context)
        {
            var app = context.GetApplicationBuilder();
            var env = context.GetEnvironment();

            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            else
            {
                app.UseExceptionHandler("/Error");
            }

            app.UseVirtualFiles();

            app.UseStaticFiles();
            app.UseRouting();

            app.UseConfiguredEndpoints(options =>
            {
                options.MapControllerRoute("app1", "{controller=App1}/{action=Index}/{id?}");
            });
        }
    }
}
