﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.FileProviders;
using System.Threading.Tasks;
using Volo.Abp.AspNetCore.Mvc;
using Volo.Abp.Http;
using Volo.Abp.VirtualFileSystem;

namespace ClassLibrary1
{
    public class App1Controller : AbpController
    {
        private readonly IVirtualFileProvider _virtualFileProvider;

        public App1Controller(IVirtualFileProvider virtualFileProvider)
        {
            _virtualFileProvider = virtualFileProvider;
        }

        public IActionResult Index()
        {
            return Content("App1 Hello World!");
        }

        public async Task<IActionResult> Text()
        {
            var fileInfo = _virtualFileProvider.GetFileInfo("/Hello.html");

            //var diectory = _virtualFileProvider.GetDirectoryContents("/ClassLibrary1/MyResources");

            //var fileString = await fileInfo.ReadAsStringAsync();
            //return Content(fileString);

            var fileBytes = await fileInfo.ReadBytesAsync();

            return File(fileBytes, MimeTypes.Text.Html);
        }
    }
}
