﻿using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.DependencyInjection;
using System;
using System.Reflection;
using Volo.Abp;
using Volo.Abp.AspNetCore.Mvc;
using Volo.Abp.Modularity;

namespace ClassLibrary2
{
    [DependsOn(typeof(AbpAspNetCoreMvcModule))]
    public class App2Module : AbpModule
    {
        public override void PreConfigureServices(ServiceConfigurationContext context)
        {
            context.Services.OnRegistred(register =>
            {
                if (register.ImplementationType == typeof(DateTimeService))
                {
                    register.Interceptors.Add<CustomAbpInterceptor>();
                }
            });

            base.PreConfigureServices(context);
        }

        public override void ConfigureServices(ServiceConfigurationContext context)
        {
            //context.Services.AddTransient<IDateTimeService, DateTimeService>();

            base.ConfigureServices(context);
        }

        public override void OnApplicationInitialization(ApplicationInitializationContext context)
        {
            context.GetApplicationBuilder().UseEndpoints(endpoints =>
            {
                endpoints.MapGet("/guid", async context =>
                {
                    await context.Response.WriteAsync(Guid.NewGuid().ToString());
                });
            });

            base.OnApplicationInitialization(context);
        }
    }
}
