﻿using BookStore.Books;
using System;
using System.Threading.Tasks;
using Volo.Abp.DependencyInjection;
using Volo.Abp.Identity;

namespace BookStore.HttpApi.Client.ConsoleTestApp
{
    public class ClientDemoService : ITransientDependency
    {
        private readonly IProfileAppService _profileAppService;

        private readonly IBookAppService _bookAppService;


        public ClientDemoService(IProfileAppService profileAppService, IBookAppService bookAppService)
        {
            _profileAppService = profileAppService;
            _bookAppService = bookAppService;
        }

        public async Task RunAsync()
        {
            await _bookAppService.CreateAsync(new CreateUpdateBookDto
            {
                Name = "C++",
                Price = 88,
                PublishDate = DateTime.Now,
                Type = BookType.Dystopia
            });

            var output = await _profileAppService.GetAsync();
            Console.WriteLine($"UserName : {output.UserName}");
            Console.WriteLine($"Email    : {output.Email}");
            Console.WriteLine($"Name     : {output.Name}");
            Console.WriteLine($"Surname  : {output.Surname}");
        }
    }
}