﻿using System.Threading.Tasks;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Localization;
using BookStore.Localization;
using BookStore.MultiTenancy;
using Volo.Abp.TenantManagement.Web.Navigation;
using Volo.Abp.UI.Navigation;

namespace BookStore.Web.Menus
{
    public class BookStoreMenuContributor : IMenuContributor
    {
        public async Task ConfigureMenuAsync(MenuConfigurationContext context)
        {
            if (context.Menu.Name == StandardMenus.Main)
            {
                await ConfigureMainMenuAsync(context);
            }
        }

        private async Task ConfigureMainMenuAsync(MenuConfigurationContext context)
        {
            //if (!MultiTenancyConsts.IsEnabled)
            //{
            //    var administration = context.Menu.GetAdministration();
            //    administration.TryRemoveMenuItem(TenantManagementMenuNames.GroupName);
            //}

            var l = context.GetLocalizer<BookStoreResource>();

            context.Menu.Items.Insert(0, new ApplicationMenuItem("BookStore.Home", l["Menu:Home"], "~/"));

            context.Menu.AddItem(new ApplicationMenuItem("BookStore", l["Menu:BookStore"])
                .AddItem(new ApplicationMenuItem("BookStore.Book", l["Menu:Book"], url: "/Books")));

            await Task.CompletedTask;
        }
    }
}
