﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using Volo.Abp.Data;
using Volo.Abp.DependencyInjection;
using Volo.Abp.Domain.Repositories;
using Volo.Abp.Guids;

namespace BookStore.Books
{
    public class BookStoreDataSeederContributor : IDataSeedContributor, ITransientDependency
    {
        private readonly IRepository<Book, Guid> _bookRepository;
        private readonly IGuidGenerator _guidGenerator;

        public BookStoreDataSeederContributor(IRepository<Book, Guid> bookRepository, IGuidGenerator guidGenerator)
        {
            _bookRepository = bookRepository;
            _guidGenerator = guidGenerator;
        }

        public async Task SeedAsync(DataSeedContext context)
        {
            if (await _bookRepository.GetCountAsync() == 0)
            {
                await _bookRepository.InsertAsync(
                   new Book(
                       id: _guidGenerator.Create(),
                       name: "ASP.NET Core",
                       type: BookType.Biography,
                       publishDate: DateTime.Now.AddDays(2),
                       price: 22.89f
                   )
               );

                await _bookRepository.InsertAsync(
                    new Book(
                        id: _guidGenerator.Create(),
                        name: "Entity Framework Core",
                        type: BookType.Fantastic,
                        publishDate: DateTime.Now.AddMonths(1),
                        price: 55.30f
                    )
                );
            }
        }
    }
}
