﻿using Microsoft.Data.SqlClient;
using Microsoft.Data.Sqlite;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Infrastructure;
using Microsoft.EntityFrameworkCore.Storage;
using Microsoft.Extensions.DependencyInjection;
using System;
using Volo.Abp;
using Volo.Abp.EntityFrameworkCore;
using Volo.Abp.EntityFrameworkCore.Sqlite;
using Volo.Abp.EntityFrameworkCore.SqlServer;
using Volo.Abp.Modularity;

namespace BookStore.EntityFrameworkCore
{
    [DependsOn(
        typeof(BookStoreEntityFrameworkCoreDbMigrationsModule),
        typeof(BookStoreTestBaseModule),
        typeof(AbpEntityFrameworkCoreSqliteModule),
        typeof(AbpEntityFrameworkCoreSqlServerModule)
        )]
    public class BookStoreEntityFrameworkCoreTestModule : AbpModule
    {
        private SqliteConnection _sqliteConnection;

        private SqlConnection _sqlConnection;

        public override void ConfigureServices(ServiceConfigurationContext context)
        {
            //ConfigureInMemorySqlite(context.Services);

            ConfigureSqlServer(context.Services);
        }

        private void ConfigureSqlServer(IServiceCollection services)
        {
            string connectionString = @"Server=(LocalDb)\MSSQLLocalDB;Database=BookStore;Trusted_Connection=True;MultipleActiveResultSets=true";

            _sqlConnection = new SqlConnection(connectionString);

            _sqlConnection.Open();

            var options = new DbContextOptionsBuilder<BookStoreMigrationsDbContext>()
                .UseSqlServer(_sqlConnection)
                .Options;

            services.Configure<AbpDbContextOptions>(options =>
            {
                options.Configure(context =>
                {
                    context.DbContextOptions.UseSqlServer(_sqlConnection);
                });
            });
        }

        private void ConfigureInMemorySqlite(IServiceCollection services)
        {
            _sqliteConnection = CreateDatabaseAndGetConnection();

            services.Configure<AbpDbContextOptions>(options =>
            {
                options.Configure(context =>
                {
                    context.DbContextOptions.UseSqlite(_sqliteConnection);
                });
            });
        }

        public override void OnApplicationShutdown(ApplicationShutdownContext context)
        {
            _sqliteConnection?.Dispose();
            _sqlConnection?.Dispose();
        }

        private static SqliteConnection CreateDatabaseAndGetConnection()
        {
            var connection = new SqliteConnection("Data Source=:memory:");
            connection.Open();

            var options = new DbContextOptionsBuilder<BookStoreMigrationsDbContext>()
                .UseSqlite(connection)
                .Options;

            using (var context = new BookStoreMigrationsDbContext(options))
            {
                context.GetService<IRelationalDatabaseCreator>().CreateTables();
            }

            return connection;
        }
    }
}
