﻿using BookStore.Books;
using Shouldly;
using System;
using System.Threading.Tasks;
using Volo.Abp.Data;
using Volo.Abp.Domain.Repositories;
using Xunit;

namespace BookStore.Samples
{
    public class BookDomainTests : BookStoreDomainTestBase
    {
        IRepository<Book, Guid> _bookRepository;

        public BookDomainTests()
        {
            _bookRepository = GetRequiredService<IRepository<Book, Guid>>();
        }

        [Fact]
        public async Task Should_Set_Extra_Properties()
        {
            var book1 = await _bookRepository.GetAsync(bk => bk.Name == "ASP.NET Core");
            book1.SetProperty("Title", "This is .NET Core book.");
            await _bookRepository.UpdateAsync(book1);

            var book2= await _bookRepository.GetAsync(bk => bk.Name == "ASP.NET Core");
            string title = book2.GetProperty<string>("Title");
            title.ShouldBe("This is .NET Core book.");
        }
    }
}
