﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using Volo.Abp.DependencyInjection;
using Volo.Abp.Domain.Entities.Events;
using Volo.Abp.Domain.Repositories;
using Volo.Abp.EventBus;
using Volo.Abp.ObjectMapping;

namespace BookStore.Books
{
    public class BookChangeEventHandler :
        ILocalEventHandler<EntityCreatedEventData<Book>>,
        ILocalEventHandler<EntityDeletedEventData<Book>>,
        ILocalEventHandler<EntityUpdatedEventData<Book>>,
        ITransientDependency
    {

        private readonly IRepository<Book2, Guid> _book2Repository;

        private readonly IObjectMapper _objectMapper;

        public BookChangeEventHandler(IRepository<Book2, Guid> book2Repository, IObjectMapper<BookStoreApplicationModule> objectMapper)
        {
            _book2Repository = book2Repository;
            _objectMapper = objectMapper;
        }

        public async Task HandleEventAsync(EntityCreatedEventData<Book> eventData)
        {
            var book2 = _objectMapper.Map<Book, Book2>(eventData.Entity);

            await _book2Repository.InsertAsync(book2);
        }

        public async Task HandleEventAsync(EntityUpdatedEventData<Book> eventData)
        {
            var book2 = await _book2Repository.GetAsync(eventData.Entity.Id);
            _objectMapper.Map(eventData.Entity, book2);
            await _book2Repository.UpdateAsync(book2);
        }

        public async Task HandleEventAsync(EntityDeletedEventData<Book> eventData)
        {
            await _book2Repository.DeleteAsync(eventData.Entity.Id);
        }
    }
}
