﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace ProductWeb.DataAccess
{
    public class ProductContext: DbContext
    {
        public ProductContext(DbContextOptions<ProductContext> options) : base(options)
        {

        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            base.OnModelCreating(modelBuilder);

            modelBuilder.Entity<Product>().HasData(
                new Product
                {
                    ProductID=1,
                    Count = 10,
                    Name = "Learning ASP.NET Core",
                    Description = "A best-selling book covering the fundamentals of ASP.NET Core"
                },
                new Product
                {
                    ProductID = 2,
                    Count=20,
                    Name = "Learning EF Core",
                    Description = "A best-selling book covering the fundamentals of Entity Framework Core"
                });
        }

        public DbSet<Product> Products { get; set; }
    }
}
