﻿using Microsoft.AspNetCore.Mvc.Testing;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using Xunit;
using AngleSharp.Extensions;
using System.Net.Http;

namespace ProductWeb.IntegratedTests
{
    public class BasicTest: IClassFixture<WebApplicationFactory<Startup>>
    {
        private readonly WebApplicationFactory<Startup> _factory;

        public BasicTest(WebApplicationFactory<Startup> factory)
        {
            _factory = factory;
        }

        [Theory]
        [InlineData("/")]
        [InlineData("/Home/Index")]
        [InlineData("/Home/About")]
        [InlineData("/Home/Contact")]
        public async Task ReturnSuccessAndCorrectContentType(string url)
        {
            // Arrange
            var client = _factory.CreateClient();

            // Act
            var response = await client.GetAsync(url);

            // Assert
            Assert.Equal("text/html; charset=utf-8", response.Content.Headers.ContentType.ToString());
        }

        [Fact]
        public async Task Get_GuidValue()
        {
            // Arrange
            var client = _factory.CreateClient();
            string url = "/Home/Index";

            // Act
            var htmlDocument = await client.GetDocumentAsync(url);

            var element = htmlDocument.QuerySelector(".test span#guid");

            // Assert

            Assert.True(element.Text().Length == 36);
        }
    }
}
