﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using ProductWeb.DataAccess;
using Microsoft.EntityFrameworkCore;

namespace ProductWeb.Services
{
    public class ProductService : IProductService
    {
        private readonly ProductContext _dbContext;

        public ProductService(ProductContext dbContext)
        {
            _dbContext = dbContext;
        }

        public async Task AddAsync(Product product)
        {
            await _dbContext.AddAsync(product);
            await _dbContext.SaveChangesAsync();
        }

        public async Task<Product> GetByIdAsync(int id)
        {
            return await _dbContext.FindAsync<Product>(id);
        }

        public async Task<IEnumerable<Product>> ListAsync()
        {
            return await _dbContext.Products.ToListAsync();
        }

        public async Task UpdateAsync(Product product)
        {
            _dbContext.Products.Update(product);
            await _dbContext.SaveChangesAsync();
        }
    }
}