﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using ProductWeb.DataAccess;
using ProductWeb.Services;

namespace ProductWeb.Controllers
{
    public class ProductController : Controller
    {

        private readonly IProductService _productService;

        public ProductController(IProductService productService)
        {
            _productService = productService;
        }

        public async Task<IActionResult> List()
        {
            var sessionList = await _productService.ListAsync();

            return View(sessionList);
        }

        [HttpPost]
        public async Task<IActionResult> Create(Product model)
        {
            if (!ModelState.IsValid)
            {
                return BadRequest(ModelState);
            }
            else
            {
                await _productService.AddAsync(model);
            }

            return RedirectToAction(actionName: nameof(List));
        }

        public async Task<IActionResult> GetProductById(int? id)
        {
            if (!id.HasValue)
            {
                return RedirectToAction(nameof(List),"Home");
            }

            var product = await _productService.GetByIdAsync(id.Value);

            if (product == null)
            {
                return Content("product not found.");
            }

            var viewModel = new Product { ProductID = 101, Name = "F#" };

            return View(viewModel);
        }
    }
}