﻿using Microsoft.AspNetCore.Mvc;
using ProductWeb.Controllers;
using ProductWeb.DataAccess;
using ProductWeb.Services;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Xunit;

namespace ProductWeb.Tests
{
    public class ProductControllerTest
    {
        private readonly ProductContext _dbContext;

        public ProductControllerTest()
        {
            _dbContext = new ProductContext(Utilities.TestDbContextOptions());

        }

        [Fact]
        public async Task List_ReturnViewResult_WithListOfProducts()
        {
            //准备参数
            IProductService productService = new ProductService(_dbContext);
            var controller = new ProductController(productService);

            //调用行为
            var result = await controller.List();

            //断言

            var viewResult = Assert.IsType<ViewResult>(result);

            var model = Assert.IsAssignableFrom<IEnumerable<Product>>(viewResult.ViewData.Model);

            Assert.Equal(2, model.Count());
        }

    }
}
