﻿using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using ProductWeb.DataAccess;
using System;
using System.Collections.Generic;
using System.Text;

namespace ProductWeb.Tests
{
    public static class Utilities
    {
        public static DbContextOptions<ProductContext> TestDbContextOptions()
        {
            var serviceProvider = new ServiceCollection()
                .AddEntityFrameworkSqlServer()
                .BuildServiceProvider();

            IConfiguration config = new ConfigurationBuilder()
                .AddJsonFile("appsettings.json", true, true).Build();

            var builder = new DbContextOptionsBuilder<ProductContext>()
                .UseSqlServer(config.GetConnectionString("SqlServer"))
                .UseInternalServiceProvider(serviceProvider);

            return builder.Options;
        }
    }
}
