﻿using AngleSharp;
using AngleSharp.Html.Parser;
using Shouldly;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using Xunit;

namespace BookStore.Pages
{
    public class BookWebTests : BookStoreWebTestBase
    {
        [Fact]
        public async Task BookList()
        {
            string cultureString = "en";

            string cookieValue = WebUtility.UrlEncode($"c={cultureString}|uic={cultureString}");

            Cookie clientCookie = new Cookie(".AspNetCore.Culture", cookieValue);

            Client.DefaultRequestHeaders.Add("Cookie", clientCookie.ToString());

            var response = await GetResponseAsStringAsync("/books");

            var context = BrowsingContext.New(Configuration.Default);
            var parser = context.GetService<IHtmlParser>();
            var document = parser.ParseDocument(response);

            var trElement = document.QuerySelectorAll("th");

            trElement.Count().ShouldBe(6);

            trElement.ShouldContain(e=>e.TextContent== "Actions");
        }
    }
}
