﻿using BookStore.Localization;
using Microsoft.Extensions.Localization;
using Volo.Abp.AspNetCore.Mvc.UI.Theme.Shared.Components;
using Volo.Abp.DependencyInjection;

namespace BookStore.Web
{
    [Dependency(ReplaceServices = true)]
    public class BookStoreBrandingProvider : DefaultBrandingProvider
    {

        private readonly IStringLocalizer<BookStoreResource> _localizer;

        public BookStoreBrandingProvider(IStringLocalizer<BookStoreResource> localizer)
        {
            _localizer = localizer;
        }

        public override string AppName =>_localizer.GetString("BookStore"); 
    }
}
