﻿using Microsoft.AspNetCore.Builder;
using Microsoft.Extensions.Hosting;
using Volo.Abp;
using Volo.Abp.AspNetCore.Mvc;
using Volo.Abp.Modularity;

namespace ClassLibrary1
{
    [DependsOn(typeof(AbpAspNetCoreMvcModule))]
    public class App1Module : AbpModule
    {
        public override void OnApplicationInitialization(ApplicationInitializationContext context)
        {
            var app = context.GetApplicationBuilder();
            var env = context.GetEnvironment();

            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            else
            {
                app.UseExceptionHandler("/Error");
            }

            app.UseStaticFiles();
            app.UseRouting();

            app.UseConfiguredEndpoints(options =>
            {
                options.MapControllerRoute("app1", "{controller=App1}/{action=Index}/{id?}");
            });
        }
    }
}
