﻿using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Http;
using System;
using Volo.Abp;
using Volo.Abp.AspNetCore.Mvc;
using Volo.Abp.Modularity;

namespace ClassLibrary2
{
    [DependsOn(typeof(AbpAspNetCoreMvcModule))]
    public class App2Module : AbpModule
    {
        public override void ConfigureServices(ServiceConfigurationContext context)
        {
            //context.Services.AddSingleton<IDateTimeService, DateTimeService>();

            base.ConfigureServices(context);
        }

        public override void OnApplicationInitialization(ApplicationInitializationContext context)
        {
            context.GetApplicationBuilder().UseEndpoints(endpoints =>
            {
                endpoints.MapGet("/guid", async context =>
                {
                    await context.Response.WriteAsync(Guid.NewGuid().ToString());
                });
            });

            base.OnApplicationInitialization(context);
        }
    }
}
