﻿using Dapr.Client;
using Microsoft.AspNetCore.Mvc;

namespace BindingSample.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class EmailsController : ControllerBase
    {
        private readonly DaprClient _darpClient;

        public EmailsController(DaprClient darpClient)
        {
            _darpClient = darpClient;
        }

        [HttpGet]
        public async Task<IActionResult> SendEmailAsync()
        {
            var metadata = new Dictionary<string, string>
            {
                ["emailFrom"] = "admin@hello.me",
                ["emailTo"] = "hello@qq.com",
                ["subject"] = "This is a test message"
            };

            string body = "This is a test body";

            await _darpClient.InvokeBindingAsync("mysmtp", "create", body, metadata);

            return Ok("hello,world!");
        }
    }
}
